/*
This code replicates Figure ## CDS in the Recent episode 

Because of confidentiality issues we report aggregate CDS spreads by year-quarter



*/


clear
cls

//Adjust this this directory: 
cap cd "/Users/jicristi/Dropbox/Brookings paper/Do files/Final_submission/Replication_pkg/Data_programs/Figure 16"

use "cds_data", clear

cd "../../Figures/Figure 16"
/*
Time series plot: Avg, Avg without argentina, and Median 
*/
***Time series
g aux=500
tw (tsline cds,lc(red) lwidth(medthick)) ///
(tsline cds_wo_arg, lc(red) lwidth(medthick) lp(dash)) ///
(connected median_cds time_q,lc(red) mcolor(red) lwidth(medthick)) /// 
(tsline aux,lp(dash) lc(black) lwidth(thin)), xlabel(, nogrid)  ylabel(, nogrid) ///
xtitle("") ytitle("CDS spreads") legend(order(1 "Avg. CDS" 2 "Avg. CDS w/o Argentina" 3 "Median CDS"))
graph export "Fig16.pdf", replace

//Export to excel 
export excel using "Fig16.xlsx", sheet("Fig16") firstrow(variables) replace
